# Categorize data
total_genre_percentile_00  = min(answers_3$total_genres)
total_genre_percentile_33  = quantile(answers_3$total_genres, 0.33333)
total_genre_percentile_67  = quantile(answers_3$total_genres, 0.66667)
total_genre_percentile_100 = max(answers_3$total_genres)

#total_genre_percentile_00  = min(genre_rating_summary_binary3$total_genres)
#total_genre_percentile_33  = quantile(genre_rating_summary_binary3$total_genres, 0.33333)
#total_genre_percentile_67  = quantile(genre_rating_summary_binary3$total_genres, 0.66667)
#total_genre_percentile_100 = max(genre_rating_summary_binary3$total_genres)

RB = rbind(total_genre_percentile_00, total_genre_percentile_33, total_genre_percentile_67, total_genre_percentile_100)
dimnames(RB)[[2]] = "Value"

answers_3$total_genres_group[answers_3$total_genres >= total_genre_percentile_00 & answers_3$total_genres <  total_genre_percentile_33]  = "Lower_third"
answers_3$total_genres_group[answers_3$total_genres >= total_genre_percentile_33 & answers_3$total_genres <  total_genre_percentile_67]  = "Middle_third"
answers_3$total_genres_group[answers_3$total_genres >= total_genre_percentile_67 & answers_3$total_genres <= total_genre_percentile_100] = "Upper_third"

answers_3$total_genres_group = factor(answers_3$total_genres_group, levels=c("Lower_third", "Middle_third", "Upper_third"))

answers_3 <- within(answers_3, {
  total_genres_group <- factor(total_genres_group)
  s_nov <- factor(s_nov)
  m_nov <- factor(m_nov)
  unexp_rel <- factor(unexp_rel)
  unexp_find <- factor(unexp_find)
  unexp_imp <- factor(unexp_imp)
  unexp_rec <- factor(unexp_rec)
  s_ser_rel <-  factor(s_ser_rel)
  s_ser_find <- factor(s_ser_find)
  s_ser_imp <- factor(s_ser_imp)
  s_ser_rec <- factor(s_ser_rec)
  m_ser_rel <- factor(m_ser_rel)
  m_ser_imp <- factor(m_ser_imp)
  m_ser_rec <- factor(m_ser_rec)
  s_nov <- factor(s_nov)
  m_nov <- factor(m_nov)
  unexp_rel <- factor(unexp_rel)
  unexp_find <- factor(unexp_find)
  unexp_imp <- factor(unexp_imp)
  unexp_rec <- factor(unexp_rec)
  broadened <- factor(broadened)
  satisfied <- factor(satisfied)
})

# total_genres: total genre yang dirating user, tidak kumulatif, min:0, max:19
# cara mendapatkan: ratings group by user distinct genre
# nov (novelty): 1-logpop --> logpop: ratings group by movie log(n())
# predictedRating: in dataset, menggambarkan kedekatan item terhadap profil user (semakin besar/mendekati 5 maka semakin dekat)


# logpop and relevance only

model_s1_ser <- clm(s1 ~ logpop+predictedRating, data=answers_3)
model_s2_ser <- clm(s2 ~ logpop+predictedRating, data=answers_3)
model_s3_ser <- clm(s3 ~ logpop+predictedRating, data=answers_3)
model_s4_ser <- clm(s4 ~ logpop+predictedRating, data=answers_3)
model_s5_ser <- clm(s5 ~ logpop+predictedRating, data=answers_3)
model_s6_ser <- clm(s6 ~ logpop+predictedRating, data=answers_3)
model_s7_ser <- clm(s7 ~ logpop+predictedRating, data=answers_3)
model_s8_ser <- clm(s8 ~ logpop+predictedRating, data=answers_3)

# combined

# s1: metrik s_nov (1-5) strict novelty --> predictedRating, logpop signifikan
model_s_nov <- clm(s1 ~ total_genres + logpop + predictedRating, data=answers_3)
# s2: metrik m_nov (1-5) motivational novelty --> predictedRating signifikan
model_m_nov <- clm(s2 ~ total_genres + logpop + predictedRating, data=answers_3)
#s3: metrik unexp_rel (1-5) unexpected relevance --> predictedRating signifikan
model_unexp_rel <- clm(s3 ~ total_genres + logpop + predictedRating, data=answers_3)
# s4: metrik unexp_find (1-5) unexpected find --> logpop, predictedRating signifikan
model_unexp_find <- clm(s4 ~ total_genres + logpop + predictedRating, data=answers_3)
#s5: metrik unexp_imp (1-5) unexpected implicit --> semua prediktor signifikan (logpop>total_genres>predictedRating)
model_unexp_imp <- clm(s5 ~ total_genres + logpop + predictedRating, data=answers_3)
# s6: metrik unexp_rec (1-5) unexpected recommend --> semua prediktor signifikan (logpop>total_genres>predictedRating)
model_unexp_rec <- clm(s6 ~ total_genres + logpop + predictedRating, data=answers_3)
# s7: metrik ordinal (1-5) tingkat kepuasan pengguna, in dataset --> predictedeRating signifikan
model_satisfy_ord <- clm(s7 ~ total_genres + logpop + predictedRating, data=answers_3)
# s8: metrik ordinal (1-5) preference broadening --> semua prediktor signifikan
model_broaden_ord <- clm(s8 ~ total_genres + logpop + predictedRating, data=answers_3)
